-- The message box to warn you about various things.
local t = Def.ActorFrame{
	OnCommand=function(self) self:aux(0):diffusealpha(0):playcommand("CurrentSongChangedMessage") end,
	Def.Quad{
		InitCommand=function(self) self:zoomto((_screen.cx/2)+30, 60):diffuse(LocalGoldColor(0)) end
	},
	LoadActor(THEME:GetPathG("_frame","3x3"), "glo", _screen.cx/2, 30) .. {
		Name = "Frame",
		InitCommand=function(self)  end
	},
	Def.BitmapText{
		Name = "Message",
		Font = "Common Normal",
		OnCommand=function(self)
			self:horizalign(left):x(-_screen.cx/4):zoom(0.4):strokecolor(Color.Black):maxwidth(((_screen.cx/2)-6)/0.4):wrapwidthpixels(((_screen.cx/2)-6)/0.4)
		end
	},
	
	CurrentSongChangedMessageCommand=function(self)
		local song = GAMESTATE:GetCurrentSong()
		local result = false
		
		-- todo: make significantly neater
		if song then
			local songDir = song:GetSongDir()
			if string.find(songDir, "/%[!%] ") then
				result = true
				self:GetChild("Message"):settext(THEME:GetString("ScreenSelectMusic", "NotifExplicit1"))
				self:GetChild("Frame"):diffuse(NeonColor.Yellow)
			elseif string.find(songDir, "/%[!!%] ") then
				result = true
				self:GetChild("Message"):settext(THEME:GetString("ScreenSelectMusic", "NotifExplicit2"))
				self:GetChild("Frame"):diffuse(LocalGoldColor(1))
			elseif string.find(songDir, "/%[!!!%] ") then
				result = true
				self:GetChild("Message"):settext(THEME:GetString("ScreenSelectMusic", "NotifExplicit3"))
				self:GetChild("Frame"):diffuse(NeonColor.Red)
			end
		end
		
		if result == false and self:getaux() == 1 then
			self:aux(0):playcommand("MsgHide")
		elseif result == true and self:getaux() == 0 then
			self:aux(1):playcommand("MsgShow")
		end
	end,
	
	MsgShowCommand=function(self)
		self:GetChild("Message"):visible(true)
		self:finishtweening():zoomy(0.05):glow(Color.White):linear(0.1):diffusealpha(1):linear(0.3):zoomy(1):glow(Color.Invisible)
	end,
	MsgHideCommand=function(self)
		self:GetChild("Message"):visible(false)
		self:finishtweening():linear(0.4):zoomy(0.05):glow(Color.White):diffusealpha(0):linear(0.05):glow(Color.Invisible)
	end,
}

return t
